
#Computes the power of the Hotelling's T^2 test for the plots in Figure 2, 3, and 4. 


library(mnormt)

####################################################

#Computes the power of the Hotelling's T^2 test for the plot in Figure 2 (normal location problem in dimension d=10)


d=10
m=1000
n=500
iter=100

h=seq(0, 3, length.out=20)

power=vector(length=20)

rp=vector(length=iter)


for(j in 1:20)
{
  
  
  delta1<-h[j]*rep(1, d)/sqrt(m+n)	
  mu0=rep(0, d)
  mu1=delta1
  sigma0=diag(rep(1, d))
  
  
  for(i in 1:iter)
  {
    
    points1<-rmnorm(m, mu0, sigma0)
    points2<-rmnorm(n, mu1, sigma0)
    xmean<-apply(points1, 2, mean)
    ymean<-apply(points2, 2, mean)
    diff<-xmean-ymean
    vc<-(1/m+1/n)*(((m-1)*cov(points1)+(n-1)*cov(points2))/(m+n-2))
    rp[i]<-t(diff)%*%solve(vc)%*%diff

  }
  
  power[j]<-length(which(rp> qchisq(0.95, d)))/iter

}

write(as.vector(power), file="T2Normal.txt", ncolumns=1)


################################################  

#Computes the power of the Hotelling's T^2 test for the plot in Figure 3 (normal scale problem in dimension d=10)


d=10
m=1000
n=500
iter=100

h=seq(0, 3, length.out=20)

power=vector(length=20)


rp=vector(length=iter)


for(j in 1:20)
{
  
  
  mu0=rep(0, d)
  delta1<-h[j]/(m+n)^(1/2)  
  sigma0=diag(rep(1, d))
  sigma1=sigma0+delta1*diag(rep(1, d))
  

    for(i in 1:iter)
  {
    
    points1<-rmnorm(m, mu0, sigma0)
    points2<-rmnorm(n, mu0, sigma1)
    xmean<-apply(points1, 2, mean)
    ymean<-apply(points2, 2, mean)
    diff<-xmean-ymean
    vc<-(1/m+1/n)*(((m-1)*cov(points1)+(n-1)*cov(points2))/(m+n-2))
    rp[i]<-t(diff)%*%solve(vc)%*%diff

  }
  
  power[j]<-length(which(rp> qchisq(0.95, d)))/iter

}


write(as.vector(power), file="T2Scale.txt", ncolumns=1)


################################################  


#Computes the power of the Hotelling's T^2 test for the plot in Figure 4 (lognormal location problem in dimension d=10)




d=10
m=1000
n=500
iter=500
iter=100

h=seq(0, 3, length.out=20)

power=vector(length=20)


rpnull=vector(length=iter)
rp=vector(length=iter)


for(j in 1:20)
{
  
  
  delta1<-h[j]*rep(1, d)/sqrt(m+n)	
  mu0=rep(0, d)
  mu1=delta1
  sigma0=diag(rep(1, d))
  
  
  for(i in 1:iter)
  {
    
    points1<-exp(rmnorm(m, mu0, sigma0))
    points2<-exp(rmnorm(n, mu1, sigma0))
    xmean<-apply(points1, 2, mean)
    ymean<-apply(points2, 2, mean)
    diff<-xmean-ymean
    vc<-(1/m+1/n)*(((m-1)*cov(points1)+(n-1)*cov(points2))/(m+n-2))
    rp[i]<-t(diff)%*%solve(vc)%*%diff

  }
  
  power[j]<-length(which(rp> qchisq(0.95, d)))/iter

}

write(as.vector(power), file="T2Lognormal.txt", ncolumns=1)




